<?php
// Koneksi ke database
require 'koneksi.php';
require 'header2.php';

if (!isset($_SESSION['level']) || $_SESSION['level'] == "") {
    header("location: login.php");
    exit;
}

// Proses hapus data jika ada parameter 'hapus' di URL
if (isset($_GET['hapus'])) {
    $id_hapus = intval($_GET['hapus']); // Pastikan ID valid

    // Gunakan prepared statement untuk menghindari SQL Injection
    $stmt = $conn->prepare("DELETE FROM channel WHERE id = ?");
    $stmt->bind_param("i", $id_hapus);

    if ($stmt->execute()) {
        echo "<script>
                alert('Data berhasil dihapus dari kedua tabel!');
                window.location = 'penilaian2.php';
              </script>";
    } else {
        echo "<script>alert('Gagal menghapus data!');</script>";
    }

    $stmt->close(); // Menutup statement setelah selesai
}
?>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-4">
            <h2 class="text-center mb-4 py-4 bg-light rounded" style="font-size: 28px; font-weight: bold;">PENILAIAN ALTERNATIF</h2>

            <div class="card-header bg-success text-white d-flex justify-content-between align-items-center" style="font-size: 20px;">
                <span><i class="fas fa-table"></i> Data Penilaian Channel</span>
                <a href="tambah_channel.php" class="btn btn-light btn-sm">
                    <i class="fas fa-plus"></i> Tambah Data Channel
                </a>
            </div>

            <div class="card-body w-100">
                <div class="table-responsive w-100">
                    <table id="datatablesSimple" class="table table-striped table-bordered table-hover w-100">
                        <thead class="table-success text-center align-middle" style="font-size: 20px;">
                            <tr>
                                <th style="width: 5%;">No</th>
                                <th style="width: 25%;">Nama Channel</th>
                                <th style="width: 11%;">Total Views (C1)</th>
                                <th style="width: 12%;">Jumlah Subscribers (C2)</th>
                                <th style="width: 11%;">Frekuensi Unggah Video (C3)</th>
                                <th style="width: 11%;">Jumlah Video yang Diunggah (C4)</th>
                                <th style="width: 11%;">Latar Belakang Konten Kreator (C5)</th>
                                <th style="width: 8%;">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="text-center" style="font-size: 18px;">
                            <?php
                            $result = mysqli_query($conn, "SELECT * FROM channel ORDER BY id ASC");

                            $no = 1;
                            while ($row = mysqli_fetch_assoc($result)) :
                            ?>
                                <tr>
                                    <td class="align-middle"><?= $no++; ?></td>
                                    <td class="align-middle"><?= htmlspecialchars($row['nama']); ?></td>
                                    <td class="align-middle"><?= is_numeric($row['c1']) ? number_format($row['c1']) : htmlspecialchars($row['c1']); ?></td>
                                    <td class="align-middle"><?= is_numeric($row['c2']) ? number_format($row['c2']) : htmlspecialchars($row['c2']); ?></td>
                                    <td class="align-middle"><?= htmlspecialchars($row['c3']); ?></td>
                                    <td class="align-middle"><?= is_numeric($row['c4']) ? number_format($row['c4']) : htmlspecialchars($row['c4']); ?></td>
                                    <td class="align-middle"><?= htmlspecialchars($row['c5']); ?></td>
                                    <td class="align-middle">
                                        <div class="d-flex justify-content-between gap-2">
                                            <a href="ubah_penilaian2.php?id=<?= $row['id']; ?>" class="btn btn-warning btn-sm">
                                                <i class="fas fa-edit"></i> Ubah
                                            </a>
                                            <a href="penilaian2.php?hapus=<?= $row['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Yakin ingin menghapus?');">
                                                <i class="fas fa-trash-alt"></i> Hapus
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                    <div class="text-center">    
                        <br><br>
                        <a href="evaluasichannel.php" class="btn btn-lg btn-outline-success align-items-center">
                            <i class="fas fa-clipboard-list"></i>  Standar Evaluasi Penilaian Channel YouTube
                        </a>
                        <br><br>
                    </div>
                </div>
            </div>
        </div> <!-- Akhir dari card -->
    </main>
</div>

<script>
    // Memastikan navigasi bisa dibuka dan tidak macet
    document.addEventListener("DOMContentLoaded", function () {
        let sidebarToggle = document.querySelector("#sidebarToggle");
        if (sidebarToggle) {
            sidebarToggle.addEventListener("click", function (e) {
                e.preventDefault();
                document.body.classList.toggle("sb-sidenav-toggled");
            });
        }
    });
</script>
